package com.introtoandroid.viewsamples;


import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.TextView;

public class EventsActivity extends AppCompatActivity {
    private String mSaveText = null;
    private GestureDetector mGestures = null;

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (mGestures != null) {
            return mGestures.onTouchEvent(event);
        } else {
            return super.onTouchEvent(event);
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.events);

        assert getSupportActionBar() != null;
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        /* Prezentowane zdarzenia: zmiany w trybie dotyku,
        zdarzenia na całym ekranie, gest długiego naciśnięcia,
        zmiany miejsca wprowdzania przy kluczowych zdarzeniach 
        widoków -- hmm... nie działają tak jak sądziłem, może
        je pominąć...?
        */
        final TextView events = (TextView) findViewById(R.id.last_event_text);
        View all = findViewById(R.id.events_screen);
        ViewTreeObserver vto = all.getViewTreeObserver();

        vto.addOnTouchModeChangeListener(new ViewTreeObserver.OnTouchModeChangeListener() {
            public void onTouchModeChanged(boolean isInTouchMode) {
                events.setText("Touch mode: " + isInTouchMode);
            }
        });

        vto.addOnGlobalFocusChangeListener(new ViewTreeObserver.OnGlobalFocusChangeListener() {
            public void onGlobalFocusChanged(View oldFocus, View newFocus) {
                if (oldFocus != null && newFocus != null) {
                    events.setText("Miejsce wprowadzania \nz: " + oldFocus.toString() + " \ndo: "
                            + newFocus.toString());
                }
            }
        });

        Button long_press = (Button) findViewById(R.id.long_press);

        long_press.setOnLongClickListener(new View.OnLongClickListener() {
            public boolean onLongClick(View v) {
                // Już wiemy który to widok, i tak używamy przekazanego obiektu.
                events.setText("Długie kliknięcie: " + v.toString());
                return true;
            }
        });

        mGestures = new GestureDetector(this, new GestureDetector.SimpleOnGestureListener() {
            @Override
            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX,
                                   float velocityY) {
                events.setText("Przeciągnięcie! \nx= " + velocityX + "px/s\ny=" + velocityY + "px/s");
                return super.onFling(e1, e2, velocityX, velocityY);
            }

            @Override
            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX,
                                    float distanceY) {
                events.setText("Przewinięcie! \nX = " + distanceX + "\nY = " + distanceY);
                return super.onScroll(e1, e2, distanceX, distanceY);
            }
        });

        TextView focus = (TextView) findViewById(R.id.text_focus_change);

        focus.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    if (mSaveText != null) {
                        ((TextView) v).setText(mSaveText);
                    }
                } else {
                    mSaveText = ((TextView) v).getText().toString();
                    ((TextView) v).setText("");
                }
            }
        });
    }

    @Override
    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        Log.d(ViewSamplesActivity.debugTag, "Kod = " + keyCode);
        return super.onKeyMultiple(keyCode, repeatCount, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, @NonNull KeyEvent event) {
        return super.onKeyUp(keyCode, event);
    }
}